﻿// Przygotowanie kodu obsługującego przyciski menu.
home_btn.onRelease = function()
{
	gotoScreen("home");
}

tutorials_btn.onRelease = function()
{
	gotoScreen("tutorials");
}

photography_btn.onRelease = function()
{
	gotoScreen("photography");
}


function gotoScreen(screenName:String):Void
{
	loaderComponent.unload();
	loaderComponent.load(screenName + ".swf");
}

function init():Void
{
	var screenHolderHandle:MovieClip;
	var loadHandler:Object = new Object();
	
	this.createClassObject(mx.controls.Loader, "loaderComponent", this.getNextHighestDepth());
	this.createClassObject(mx.controls.ProgressBar, "progressComponent", this.getNextHighestDepth());

	progressComponent._x = Stage.width / 2 - progressComponent._width / 2;
	progressComponent._y = Stage.height / 2 - progressComponent._height / 2;
	
	progressComponent.source = loaderComponent;
	progressComponent.setStyle("color", 0x888888);
	progressComponent.setStyle("fontSize", 12);
	progressComponent.setStyle("themeColor", 0x888888);

	loadHandler.progress = function(eventObject:Object)
	{
		loaderComponent.content.stop();
		progressComponent._visible = true;
	}

	loadHandler.complete = function(eventObject:Object)
	{
		loaderComponent.content.play();
		progressComponent._visible = false;
	}
	
	loaderComponent.scaleContent = false;
	loaderComponent.addEventListener("progress", loadHandler);
	loaderComponent.addEventListener("complete", loadHandler);

	gotoScreen("home");
}

init();